% This script demonstrates the use of the Fast Spectral Correlation code
% "Fast_SC.m" on a synthetic cyclostationary signal. 



% Synthesis of an elementary cyclostationary signal
% =================================================

global x
global fr
global Fs
global Br
global Dn
global fd
global fmax
global l
% global ratio

L=length(x);
f0 =100; % cycle frequency (in Hz)

figure
plot((0:L-1)/Fs,x)
title('Synthetic cyclostationary signal')
xlabel('time (s)')
xlim([0 10])
% Fast Spectral Correlation
% =========================
% Analysis parameters to be fixed by the user
Nw = 2^7;               % window length (number of samples)
alpha_max = 25*f0;       % maximum cyclic frequency to scan (in Hz)
                        % (should cover the cyclic frequency range of interest)
opt.coh = 1;            % compute sepctral coherence? (yes=1, no=0)

[S,alpha,f,Nv] = Fast_SC(x,Nw,alpha_max,Fs,opt);

figure
subplot(211)
imagesc(alpha(2:end),f,abs(S(:,2:end))),axis xy,colorbar('Location','north')
if opt.coh == 0
    title('Spectral Correlation')
else 
    title('Spectral Coherence')
end
xlabel('cyclic frequency \alpha (Hz)'),ylabel('f (Hz)'),
xlim([0 alpha_max])
 
subplot(212)
plot(alpha(2:end),mean(abs(S(:,2:end))),'k')
title('Enhanced envelope spectrum')
xlabel('cyclic frequency \alpha (Hz)'),ylabel('Amplitude'); 
xlim([0 alpha_max])

 [ijk optimum] = min(abs(alpha-fr)); % Optimum gives the position of fr in the vector alpha
 Optimummin=optimum-10;
 Optimummax=optimum+10;
 Spectrum = mean(abs(S));   
 [ijk optimum] = max(Spectrum(Optimummin:Optimummax)); % Optimum gives the position of max spectrum
 optimum=optimum+Optimummin-1; % Optimum gives the position of max spectrum
 fr_newSC=alpha(optimum);
             
%%% For signals belong to the CWRU data sets
% =========================

%if Spe ~= 0
%speedr = [1797 1772 1750 1730];

% Ratios of damage frequencies to shaft speed
ratio = [5.415 3.585 0.3983 2.357; 4.947 3.053 0.3816 1.994];
% ratio = [6.111 3.889 0.389 4.2780; 9.185 6.815 0.426 6.6020];
%fr = speedr(Spe)/60;
if Br == 1
    j = 1;
else 
    j = 2;
end
fd = fr_newSC * ratio(j, Dn);
fs=zeros(size(fr_newSC));
fside1=zeros(size(fr_newSC));
fside2=zeros(size(fr_newSC));
fside3=zeros(size(fr_newSC));
fside4=zeros(size(fr_newSC));
for k=1:length(Dn)
    if Dn(k) == 1
        fs(k) = fr_newSC;
    elseif Dn(k) == 4
        fs(k) = ratio(j,3)*fr_newSC;
    else
        fs(k) = 0;
    end
    fside1(k) = fd(k) + fs(k);
    fside2(k) = fd(k) - fs(k);
    fside3(k) = 2*fd(k) + fs(k);
    fside4(k) = 2*fd(k) - fs(k);
end

width=1;
hold on;
plot([fr_newSC fr_newSC], [0 1.2],'-.','color',[1 0 1],'LineWidth',width); % magenta
plot([2*fr_newSC 2*fr_newSC], [0 1.2],'-.','color',[1 0 1],'LineWidth',width); % magenta
plot([3*fr_newSC 3*fr_newSC], [0 1.2],'-.','color',[1 0 1],'LineWidth',width); % magenta
hold on;
for k=1:4
    if k==1
        color=[1 0 0]; % red
    elseif k==2
        color=[0 1 0]; % green
    elseif k==3
        color=[0 0 1]; % blue
    elseif k==4
        color=[0 0 0]; % black        
    end
    plot([fd(k) fd(k)], [0 1.2],'--','color',color,'LineWidth',width);
    plot(2*[fd(k) fd(k)], [0 1.2],'--','color',color,'LineWidth',width);
    plot([fside1(k) fside1(k)], [0 1.2],':','color',color,'LineWidth',width)
    plot([fside2(k) fside2(k)], [0 1.2],':','color',color,'LineWidth',width)
    plot([fside3(k) fside3(k)], [0 1.2],':','color',color,'LineWidth',width)
    plot([fside4(k) fside4(k)], [0 1.2],':','color',color,'LineWidth',width)
    xlim([0 fmax])
end
xlabel('Frequency (Hz)'),ylabel('Amplitude');
grid on, zoom on
%%

%%%% Finding damage 

fd_new1(i) = 0;
fd_new2(i) = 0;
fd_new3(i) = 0;
fd_new4(i) = 0;
fd_new5(i) = 0;
fd_new6(i) = 0;
NNN=10;
PPP=10;
deltaalpha=alpha(2)-alpha(1);
percent = 0.03;
Error_2(i) = 0;
Error_3(i) = 0;
Error_4(i) = 0;
Error_5(i) = 0;
Error_6(i) = 0;

for i = 1:length(l)
    harmonics = l(i);  % Harmonic_column

 if fd(l(i))+NNN*deltaf<fmax && fd(l(i))<alpha(end)
    [ijk optimum] = min(abs(alpha-fd(harmonics)));        %1st harmonic
    Optimummin=optimum-ceil(NNN/2);
    Optimummax=optimum+ceil(PPP/2);
    [ijk optimum] = max(Spectrum(Optimummin:Optimummax)); 
    optimum=optimum+Optimummin-1; 
    fd_new1(i) = Spectrum(optimum);

    fd(harmonics)=alpha(optimum);
    fup = (1+percent)*fd(harmonics);
    fdown = (1-percent)*fd(harmonics);
    indices = find(fdown <= alpha & alpha <= fup);
    abc=Spectrum; % temporary variable
    abc(optimum-1:optimum+1)=0;
    bca=abc(indices);
    clear abc
    mu = mean(bca);
    Error_1(i) = (fd_new1(i) - mu)/fd_new1(i);     %Error at 1st harmonic
 end

if 2*fd(l(i))+10*deltaalpha<fmax && 2*fd(l(i))<alpha(end)
    [ijk, optimum] = min(abs(alpha-2*fd(harmonics)));             % 2nd harmonic
    Optimummin = optimum-ceil(NNN/2);
    Optimummax = optimum+ceil(PPP/2);
    [ijk, optimum] = max(Spectrum(Optimummin:Optimummax)); 
    optimum = optimum + Optimummin - 1; 
    fd_new2(i) = Spectrum(optimum);

    fd(harmonics)=alpha(optimum);
    fup = (1+percent)*fd(harmonics);
    fdown = (1-percent)*fd(harmonics);
    indices = find(fdown <= alpha & alpha <= fup);
    abc=Spectrum; % temporary variable
    abc(optimum-1:optimum+1)=0;
    bca=abc(indices);
    clear abc
    mu = mean(bca);
    Error_2(i) = (fd_new2(i) - mu)/fd_new2(i);     %Error at 2nd harmonic
end
end

if any(l==1) || any(l==4)   %setting outer_race & cage sidebands to 0

if fside1(l(i))+10*deltaalpha<fmax && fside1(l(i))<alpha(end)
   [ijk optimum] = min(abs(alpha-fside1(harmonics)));                %1st sideband
   Optimummin=optimum-ceil(NNN/2);
   Optimummax=optimum+ceil(PPP/2);
   [ijk optimum] = max(Spectrum(Optimummin:Optimummax)); 
   optimum=optimum+Optimummin-1; 
   fd_new3(i) = Spectrum(optimum);

   fside1(harmonics)=alpha(optimum);
   fup = (1+percent)*fside1(harmonics);
   fdown = (1-percent)*fside1(harmonics);
   indices = find(fdown <= alpha & alpha <= fup);
   abc=Spectrum; % temporary variable
   abc(optimum-1:optimum+1)=0;
   bca=abc(indices);
   clear abc
   mu = mean(bca);
   Error_3(i) = (fd_new3(i) - mu)/fd_new3(i);     %Error at 1st sideband
end

if fside2(l(i))+10*deltaalpha<fmax && fside2(l(i))<alpha(end)
   [ijk optimum] = min(abs(alpha-fside2(harmonics)));                %2nd sideband
   Optimummin=optimum-ceil(NNN/2);
   Optimummax=optimum+ceil(PPP/2);
   [ijk optimum] = max(Spectrum(Optimummin:Optimummax)); 
   optimum=optimum+Optimummin-1; 
   fd_new4(i) = Spectrum(optimum);

   fside2(harmonics)=alpha(optimum);
   fup = (1+percent)*fside2(harmonics);
   fdown = (1-percent)*fside2(harmonics);
   indices = find(fdown <= alpha & alpha <= fup);
   abc=Spectrum; % temporary variable
   abc(optimum-1:optimum+1)=0;
   bca=abc(indices);
   clear abc
   mu = mean(bca);
   Error_4(i) = (fd_new4(i) - mu)/fd_new4(i);     %Error at 2nd sideband
end

if fside3(l(i))+10*deltaalpha<fmax  && fside3(l(i))<alpha(end)
   [ijk optimum] = min(abs(alpha-fside3(harmonics)));                %3rd sideband
   Optimummin=optimum-ceil(NNN/2);
   Optimummax=optimum+ceil(PPP/2);
   [ijk optimum] = max(Spectrum(Optimummin:Optimummax)); 
   optimum=optimum+Optimummin-1; 
   fd_new5(i) = Spectrum(optimum);

   fside3(harmonics)=alpha(optimum);
   fup = (1+percent)*fside3(harmonics);
   fdown = (1-percent)*fside3(harmonics);
   indices = find(fdown <= alpha & alpha <= fup);
   abc=Spectrum; % temporary variable
   abc(optimum-1:optimum+1)=0;
   bca=abc(indices);
   clear abc
   mu = mean(bca);
   Error_5(i) = (fd_new5(i) - mu)/fd_new5(i);     %Error at 3rd sideband
end

if fside4(l(i))+10*deltaalpha<fmax && fside4(l(i))<alpha(end)
   [ijk optimum] = min(abs(alpha-fside4(harmonics)));                %4th sideband
   Optimummin=optimum-ceil(NNN/2);
   Optimummax=optimum+ceil(PPP/2);
   [ijk optimum] = max(Spectrum(Optimummin:Optimummax)); 
   optimum=optimum+Optimummin-1; 
   fd_new6(i) = Spectrum(optimum);

   fside4(harmonics)=alpha(optimum);
   fup = (1+percent)*fside4(harmonics);
   fdown = (1-percent)*fside4(harmonics);
   indices = find(fdown <= alpha & alpha <= fup);
   abc=Spectrum; % temporary variable
   abc(optimum-1:optimum+1)=0;
   bca=abc(indices);
   clear abc
   mu = mean(bca);
   Error_6(i) = (fd_new6(i) - mu)/fd_new6(i);     %Error at 4th sideband
end

end % if l==1 || l==4

Total_damage_1 = 0;
Total_damage_2 = 0;
Total_damage_3 = 0;
Total_damage_4 = 0;
Error_SC_1 = 0;
Error_SC_2 = 0;
Error_SC_3 = 0;
Error_SC_4 = 0;

for i = 1:length(l)
    damage = l(i);

if damage == 1  %Inner_race 
   Total_damage_1 = fd_new1(i)+fd_new2(i)+fd_new3(i)+fd_new4(i)+fd_new5(i)+fd_new6(i); 
   Error_SC_1 = (Error_1+Error_2+Error_3+Error_4+Error_5+Error_6)/6;  %Indication of total error for harmonics with its sidebands  

end
if damage == 2  %Outer_race 
   Total_damage_2 = fd_new1(i)+fd_new2(i);
   Error_SC_2 = (Error_1(i)+Error_2(i))/2; %Indication of total error for harmonics
end

if damage == 3  %Cage
   Total_damage_3 = fd_new1(i)+fd_new2(i);
   Error_SC_3 = (Error_1(i)+Error_2(i))/2;  %Indication of total error for harmonics
end

if damage == 4  %Ball
   Total_damage_4 = fd_new1(i)+fd_new2(i)+fd_new3(i)+fd_new4(i)+fd_new5(i)+fd_new6(i);
   Error_SC_4 = (Error_1(i)+Error_2(i)+Error_3(i)+Error_4(i)+Error_5(i)+Error_6(i))/6;  %Indication of total error for harmonics with its sidebands  
end
end

if any(l==1)
    Error_SC = Error_SC_1;
end 
if any(l==2)
    Error_SC = Error_SC_2;
end 
if (l==4)
    Error_SC = Error_SC_4;
end 
if any(l==3) && any(l==4)
    Error_SC = (Error_SC_3+Error_SC_4)/2;
end 

Total_damage = Total_damage_1+Total_damage_2+Total_damage_3+Total_damage_4;         %Total damage

filter_values = [fd_new1,fd_new2,fd_new3,fd_new4,fd_new5,fd_new6];  %filter_values of max. peak values from the spectrum
indices_to_filter = ismember(Spectrum, filter_values);
Spectrum_New = Spectrum(~indices_to_filter);  %To get new spectrum 

damage_SC = Total_damage/rms(Spectrum_New);      %damage
tmp=sort(S_New,'descend');
MMM=50;
damage_SC_tmp = Total_damage/rms(tmp(1:MMM));      %damage

median_value = rms(Spectrum_New);    
width = 1;
yline(median_value, 'r-','LineWidth',width) %plot the new median value of the RMS of the spectrum
%%

% It may happen that the resolution of the computer screen is not enough to
% display all the details in the spectral correlation; in this case, a solution
% is to decrease the cyclic spectral resolution by smoothing.

screen_resolution = 1080;       % number of vertical lines
Na = length(alpha);
N = round(Na/screen_resolution);
w = hamming(2*N+1);
if N > 1
    Smooth = zeros(Nw/2+1,Na);
    for k = 1:Nw/2+1
        Smooth(k,:) = conv(abs([0 S(k,2:end)]),w,'same');
    end
    
    figure,
    imagesc(alpha(2:end),f,Smooth),axis xy,colorbar('Location','north')
    if opt.coh == 0
        title('Smoothed spectral Correlation')
    else
        title('Smoothed spectral Coherence')
    end
    xlabel('cyclic frequency \alpha (Hz)'),ylabel('f (Hz)'),
    xlim([0 alpha_max])
end



